/*
 * Decompiled with CFR 0.152.
 */
package dev.compactmods.crafting.lib.reactivex.rxjava3.internal.operators.mixed;

import dev.compactmods.crafting.lib.reactivestreams.Subscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.core.FlowableSubscriber;
import dev.compactmods.crafting.lib.reactivex.rxjava3.exceptions.MissingBackpressureException;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.AtomicThrowable;
import dev.compactmods.crafting.lib.reactivex.rxjava3.internal.util.ErrorMode;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.QueueSubscription;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SimpleQueue;
import dev.compactmods.crafting.lib.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class ConcatMapXMainSubscriber<T>
extends AtomicInteger
implements FlowableSubscriber<T> {
    private static final long serialVersionUID = -3214213361171757852L;
    final AtomicThrowable errors;
    final int prefetch;
    final ErrorMode errorMode;
    SimpleQueue<T> queue;
    Subscription upstream;
    volatile boolean done;
    volatile boolean cancelled;
    boolean syncFused;

    public ConcatMapXMainSubscriber(int prefetch, ErrorMode errorMode) {
        this.errorMode = errorMode;
        this.errors = new AtomicThrowable();
        this.prefetch = prefetch;
    }

    @Override
    public final void onSubscribe(Subscription s) {
        if (SubscriptionHelper.validate(this.upstream, s)) {
            this.upstream = s;
            if (s instanceof QueueSubscription) {
                QueueSubscription qs = (QueueSubscription)s;
                int mode = qs.requestFusion(7);
                if (mode == 1) {
                    this.queue = qs;
                    this.syncFused = true;
                    this.done = true;
                    this.onSubscribeDownstream();
                    this.drain();
                    return;
                }
                if (mode == 2) {
                    this.queue = qs;
                    this.onSubscribeDownstream();
                    this.upstream.request(this.prefetch);
                    return;
                }
            }
            this.queue = new SpscArrayQueue<T>(this.prefetch);
            this.onSubscribeDownstream();
            this.upstream.request(this.prefetch);
        }
    }

    @Override
    public final void onNext(T t) {
        if (t != null && !this.queue.offer(t)) {
            this.upstream.cancel();
            this.onError(new MissingBackpressureException("queue full?!"));
            return;
        }
        this.drain();
    }

    @Override
    public final void onError(Throwable t) {
        if (this.errors.tryAddThrowableOrReport(t)) {
            if (this.errorMode == ErrorMode.IMMEDIATE) {
                this.disposeInner();
            }
            this.done = true;
            this.drain();
        }
    }

    @Override
    public final void onComplete() {
        this.done = true;
        this.drain();
    }

    final void stop() {
        this.cancelled = true;
        this.upstream.cancel();
        this.disposeInner();
        this.errors.tryTerminateAndReport();
        if (this.getAndIncrement() == 0) {
            this.queue.clear();
            this.clearValue();
        }
    }

    void clearValue() {
    }

    abstract void onSubscribeDownstream();

    abstract void disposeInner();

    abstract void drain();
}

